<?php
session_start();

// Define the entire survey structure
$survey_structure = [
    'Emotional & Mental Well-being' => [
        ['key' => 'feeling_sad', 'question' => 'Do you often feel sad, tearful, or empty for much of the day?'],
        ['key' => 'constant_worry', 'question' => 'Do you find yourself worrying constantly, with racing thoughts you can\'t turn off?'],
        ['key' => 'anger_irritability', 'question' => 'Do you experience sudden moments of anger or irritability that feel out of your control?'],
        ['key' => 'feeling_guilty', 'question' => 'Do you feel guilty or like you are failing as a mother?'],
        ['key' => 'feeling_overwhelmed', 'question' => 'Do you feel overwhelmed by even small tasks?'],
        ['key' => 'lost_interest', 'question' => 'Have you lost interest in activities you used to enjoy?'],
        ['key' => 'disconnected_from_baby', 'question' => 'Do you feel disconnected or distant from your baby?'],
        ['key' => 'lost_identity', 'question' => 'Do you feel like you\'ve lost your own identity since becoming a mother?'],
        ['key' => 'trouble_sleeping', 'question' => 'Are you having trouble sleeping, even when the baby is asleep?'],
        ['key' => 'lonely_isolated', 'question' => 'Do you feel intensely lonely or isolated from others?']
    ],
    'Physical Recovery & Body' => [
        ['key' => 'perineal_pain', 'question' => 'Are you experiencing significant pain or discomfort in your perineal area?'],
        ['key' => 'csection_pain', 'question' => 'Are you struggling with pain or slow healing around your C-section incision?'],
        ['key' => 'bleeding_concerns', 'question' => 'Are you concerned about the amount of postpartum bleeding you\'re having?'],
        ['key' => 'breast_pain', 'question' => 'Do you experience painful breast engorgement, swelling, or hardness?'],
        ['key' => 'leaking_urine', 'question' => 'Do you leak urine when you cough, sneeze, or laugh?'],
        ['key' => 'fatigue_exhaustion', 'question' => 'Do you feel a deep sense of exhaustion that sleep doesn\'t seem to fix?'],
        ['key' => 'body_image_issues', 'question' => 'Do you feel disconnected from or unhappy with your postpartum body?'],
        ['key' => 'pressure_to_bounce_back', 'question' => 'Do you feel pressure to "bounce back" to your pre-pregnancy body quickly?']
    ],
    'My Baby\'s Care & Behavior' => [
        ['key' => 'prolonged_crying', 'question' => 'Does your baby cry for long periods, and you struggle to soothe them?'],
        ['key' => 'interpreting_cues', 'question' => 'Are you unsure how to interpret your baby\'s different cries or cues?'],
        ['key' => 'unpredictable_sleep', 'question' => 'Does your baby\'s sleep feel completely unpredictable and chaotic?'],
        ['key' => 'baby_health_worries', 'question' => 'Do you worry constantly about your baby\'s health or safety?'],
        ['key' => 'reflux_gas_pain', 'question' => 'Does your baby seem to be in pain from gas or spitting up frequently (reflux)?'],
        ['key' => 'only_sleeps_held', 'question' => 'Does your baby only seem to fall asleep when being held by you?']
    ],
    'Feeding My Baby' => [
        ['key' => 'breastfeeding_pain', 'question' => 'Are you experiencing pain, cracked nipples, or discomfort while breastfeeding?'],
        ['key' => 'latching_issues', 'question' => 'Is your baby struggling to get a good latch on the breast?'],
        ['key' => 'low_milk_supply_worries', 'question' => 'Are you worried that you are not producing enough milk for your baby?'],
        ['key' => 'pumping_logistics', 'question' => 'Are you struggling with the logistics and time commitment of pumping milk?'],
        ['key' => 'feeling_tied_down', 'question' => 'Do you feel "tied down" or restricted by your baby\'s feeding schedule?'],
        ['key' => 'feeding_pressure', 'question' => 'Do you feel pressured by others about your choice to breastfeed or formula-feed?']
    ],
    'Relationships & Social Support' => [
        ['key' => 'partner_arguments', 'question' => 'Do you and your partner find yourselves arguing more often since the baby arrived?'],
        ['key' => 'intimacy_issues', 'question' => 'Are you avoiding intimacy with your partner due to pain, exhaustion, or low desire?'],
        ['key' => 'mental_load', 'question' => 'Do you feel that the "mental load" (keeping track of everything) falls mostly on you?'],
        ['key' => 'feeling_lonely', 'question' => 'Do you feel lonely, even when you are surrounded by people?'],
        ['key' => 'boundary_setting', 'question' => 'Are you struggling to set boundaries with family (like in-laws) regarding visits or advice?']
    ],
    'Daily Life & Household Logistics' => [
        ['key' => 'chaotic_home', 'question' => 'Does your home feel chaotic and are you overwhelmed by household chores?'],
        ['key' => 'no_time_for_shower', 'question' => 'Do you struggle to find time for a shower or to get dressed for the day?'],
        ['key' => 'skipping_meals', 'question' => 'Do you find yourself skipping meals or eating poorly because you have no time?'],
        ['key' => 'no_time_for_self', 'question' => 'Do you feel like you have absolutely no time for yourself?']
    ],
    'Work, Finances & The Future' => [
        ['key' => 'anxious_return_to_work', 'question' => 'Are you feeling anxious or stressed about returning to work?'],
        ['key' => 'childcare_worries', 'question' => 'Are you concerned about finding or affording quality childcare?'],
        ['key' => 'financial_strain', 'question' => 'Are you worried about the financial strain of a new baby?'],
        ['key' => 'career_impact_worries', 'question' => 'Do you worry that taking time off will negatively impact your career?']
    ]
];

// Flatten the structure into a simple questions array
$all_questions = [];
foreach ($survey_structure as $category => $questions) {
    foreach ($questions as $question_data) {
        $all_questions[] = [
            'category' => $category,
            'key' => $question_data['key'],
            'question' => $question_data['question']
        ];
    }
}
$total_questions = count($all_questions);

// --- LOGIC ---
$current_q_index = 0;
// If form is submitted, process answer and increment index
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_q_index = isset($_POST['current_q']) ? (int)$_POST['current_q'] : 0;
    $answer = isset($_POST['answer']) ? $_POST['answer'] : 'no';

    // Store the answer
    if ($current_q_index < $total_questions) {
        $question_key = $all_questions[$current_q_index]['key'];
        $_SESSION['answers'][$question_key] = [
            'question' => $all_questions[$current_q_index]['question'],
            'category' => $all_questions[$current_q_index]['category'],
            'answer' => $answer
        ];
    }
    
    // Move to the next question
    $current_q_index++;
} else {
    // This is the first visit, clear any old answers
    $_SESSION['answers'] = [];
}

// If we're past the last question, redirect to results
if ($current_q_index >= $total_questions) {
    header('Location: results.php');
    exit;
}

// Get the current question details
$current_category = $all_questions[$current_q_index]['category'];
$current_question_text = $all_questions[$current_q_index]['question'];
$progress_percentage = ($current_q_index / $total_questions) * 100;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assessment In Progress</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="progress-bar-container">
                <div class="progress-bar" style="width: <?php echo $progress_percentage; ?>%;"></div>
            </div>
            
            <h2 class="category-title"><?php echo htmlspecialchars($current_category); ?></h2>
            <p class="question-text"><?php echo htmlspecialchars($current_question_text); ?></p>
            
            <form action="assessment.php" method="post" id="assessment-form">
                <input type="hidden" name="current_q" value="<?php echo $current_q_index; ?>">
                <div class="button-group">
                    <button type="submit" name="answer" value="yes" class="btn btn-yes">Yes</button>
                    <button type="submit" name="answer" value="no" class="btn btn-no">No</button>
                </div>
            </form>
        </div>
        <div class="text-center small-text">
            <p>Your answers are confidential and help us tailor your results.</p>
        </div>
    </div>
</body>
</html>