<?php
session_start();

// Check if answers exist, otherwise redirect to start
if (!isset($_SESSION['answers']) || empty($_SESSION['answers'])) {
    header('Location: index.php');
    exit;
}

$all_answers = $_SESSION['answers'];
$results = [];

// Group "yes" answers by category
foreach ($all_answers as $key => $data) {
    if ($data['answer'] === 'yes') {
        $category = $data['category'];
        if (!isset($results[$category])) {
            $results[$category] = [];
        }
        $results[$category][] = $data['question'];
    }
}

// Clear the session answers now that we have processed them
session_unset();
session_destroy();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Personalized Results</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <div class="card">
            <h1>Your Personalized Guide</h1>
            <p class="lead">Thank you for taking the time to reflect. Based on your answers, here are the areas where a little extra support might be helpful, along with guides tailored to you.</p>
        </div>

        <?php if (empty($results)): ?>
            <div class="card result-category">
                <h2>All Clear!</h2>
                <p>Based on your answers, it seems you're navigating things smoothly right now. Remember that the postpartum journey has ups and downs, and you can always come back if new challenges arise.</p>
            </div>
        <?php else: ?>
            <?php foreach ($results as $category => $questions): ?>
                <div class="card result-category">
                    <h2><?php echo htmlspecialchars($category); ?></h2>
                    <p>It looks like you're facing some challenges here. Specifically, you mentioned:</p>
                    <ul class="result-list">
                        <?php foreach ($questions as $question): ?>
                            <li><?php echo htmlspecialchars($question); ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <hr>
                    <div class="guide-placeholder">
                        <h3>Recommended Guides for You:</h3>
                        <p><em>[Placeholder: A list of relevant digital guides and links will be displayed here based on the specific "yes" answers in this category.]</em></p>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

         <div class="card text-center">
            <p><strong>Disclaimer:</strong> This assessment is a supportive tool, not a medical diagnosis. If you are concerned about your mental or physical health, please contact a healthcare professional.</p>
            <a href="index.php" class="btn btn-secondary">Start Over</a>
        </div>
    </div>
</body>
</html>