<?php
// PHP block to securely get and sanitize URL parameters for pre-populating the form
$pre_name = isset($_GET['name']) ? htmlspecialchars(trim($_GET['name']), ENT_QUOTES, 'UTF-8') : '';
$pre_email = isset($_GET['email']) ? htmlspecialchars(trim($_GET['email']), ENT_QUOTES, 'UTF-8') : '';
$pre_phone = isset($_GET['phone']) ? htmlspecialchars(trim($_GET['phone']), ENT_QUOTES, 'UTF-8') : '';

// The entire survey structure in PHP. We will pass this to JavaScript.
$survey_structure = [
    'Emotional & Mental Well-being' => [
        ['key' => 'feeling_sad', 'question' => 'Do you often feel sad, tearful, or empty for much of the day?'],
        ['key' => 'constant_worry', 'question' => 'Do you find yourself worrying constantly, with racing thoughts you can\'t turn off?'],
        ['key' => 'anger_irritability', 'question' => 'Do you experience sudden moments of anger or irritability that feel out of your control?'],
        ['key' => 'feeling_guilty', 'question' => 'Do you feel guilty or like you are failing as a mother?']
    ],
    'Physical Recovery & Body' => [
        ['key' => 'perineal_pain', 'question' => 'Are you experiencing significant pain or discomfort in your perineal area?'],
        ['key' => 'csection_pain', 'question' => 'Are you struggling with pain or slow healing around your C-section incision?'],
        ['key' => 'leaking_urine', 'question' => 'Do you leak urine when you cough, sneeze, or laugh?'],
        ['key' => 'fatigue_exhaustion', 'question' => 'Do you feel a deep sense of exhaustion that sleep doesn\'t seem to fix?']
    ],
    'My Baby\'s Care & Behavior' => [
        ['key' => 'prolonged_crying', 'question' => 'Does your baby cry for long periods, and you struggle to soothe them?'],
        ['key' => 'unpredictable_sleep', 'question' => 'Does your baby\'s sleep feel completely unpredictable and chaotic?'],
        ['key' => 'baby_health_worries', 'question' => 'Do you worry constantly about your baby\'s health or safety?']
    ],
    'Feeding My Baby' => [
        ['key' => 'breastfeeding_pain', 'question' => 'Are you experiencing pain, cracked nipples, or discomfort while breastfeeding?'],
        ['key' => 'latching_issues', 'question' => 'Is your baby struggling to get a good latch on the breast?'],
        ['key' => 'low_milk_supply_worries', 'question' => 'Are you worried that you are not producing enough milk for your baby?']
    ],
    'Relationships & Social Support' => [
        ['key' => 'partner_arguments', 'question' => 'Do you and your partner find yourselves arguing more often since the baby arrived?'],
        ['key' => 'intimacy_issues', 'question' => 'Are you avoiding intimacy with your partner due to pain, exhaustion, or low desire?'],
        ['key' => 'mental_load', 'question' => 'Do you feel that the "mental load" (keeping track of everything) falls mostly on you?']
    ],
    'Daily Life & Household Logistics' => [
        ['key' => 'chaotic_home', 'question' => 'Does your home feel chaotic and are you overwhelmed by household chores?'],
        ['key' => 'no_time_for_shower', 'question' => 'Do you struggle to find time for a shower or to get dressed for the day?'],
        ['key' => 'no_time_for_self', 'question' => 'Do you feel like you have absolutely no time for yourself?']
    ],
    'Work, Finances & The Future' => [
        ['key' => 'anxious_return_to_work', 'question' => 'Are you feeling anxious or stressed about returning to work?'],
        ['key' => 'childcare_worries', 'question' => 'Are you concerned about finding or affording quality childcare?'],
        ['key' => 'financial_strain', 'question' => 'Are you worried about the financial strain of a new baby?']
    ]
];
$categories = array_keys($survey_structure);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Postpartum Support Assessment</title>
    <link href="https://fonts.googleapis.com/css2?family=Lora:wght@400;600;700&family=Nunito+Sans:wght@400;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Nunito Sans', sans-serif; font-size: 18px; line-height: 1.7; color: #333333; background-color: #F0EBE8; padding: 20px; }
        .container { max-width: 750px; margin: 40px auto; background-color: #FFFFFF; padding: 40px; border-radius: 16px; box-shadow: 0 8px 32px rgba(0,0,0,0.1); }
        h1, h2, h3 { font-family: 'Lora', serif; font-weight: 700; margin-bottom: 18px; }
        h1 { font-size: 42px; color: #333333; text-align: center; margin-bottom: 24px; line-height: 1.2; }
        h2 { font-size: 32px; color: #D98B96; margin-top: 36px; margin-bottom: 24px; text-align: center; }
        h3 { font-size: 24px; font-weight: 600; margin-top: 24px; margin-bottom: 18px; text-align: center;}
        .subheadline { font-size: 24px; color: #D98B96; text-align: center; margin-bottom: 36px; font-weight: 600; }
        p { margin-bottom: 24px; font-weight: 400; }
        .text-center { text-align: center; }
        .cta-button { display: inline-block; background-color: #FF9900; color: #333333; font-family: 'Nunito Sans', sans-serif; font-weight: 700; font-size: 20px; padding: 16px 32px; border-radius: 12px; text-decoration: none; text-align: center; margin: 24px auto; display: block; max-width: 400px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); transition: all 0.3s ease; cursor: pointer; border: none; }
        .cta-button:hover { transform: translateY(-2px); box-shadow: 0 6px 16px rgba(0,0,0,0.2); filter: brightness(1.05); }
        .emphasis { font-weight: 700; color: #D98B96; }
        
        .page-section { display: none; animation: fadeIn 0.6s ease; }
        .page-section.active { display: block; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(15px); } to { opacity: 1; transform: translateY(0); } }

        .survey-buttons { display: flex; justify-content: center; gap: 20px; margin-top: 30px; }
        .survey-btn { font-size: 18px; padding: 12px 40px; }
        #progress-bar-container { width: 100%; background-color: #eee; border-radius: 10px; margin-bottom: 30px; overflow: hidden; }
        #progress-bar { width: 0%; height: 20px; background-color: #D98B96; border-radius: 10px; text-align: center; color: white; line-height: 20px; transition: width 0.4s ease; font-size: 14px; }
        
        .lead-capture input { width: 100%; max-width: 400px; padding: 12px; font-size: 16px; margin: 10px auto; border: 1px solid #ccc; border-radius: 8px; display: block; }
        
        #loading-page { text-align: center; padding: 60px 20px; }
        .spinner { margin: 20px auto; width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #D98B96; border-radius: 50%; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        #loading-text { font-size: 18px; color: #666; font-style: italic; min-height: 54px; transition: opacity 0.5s ease; }

        .category-list { list-style: none; padding: 0; margin: 30px 0; max-width: 450px; margin-left: auto; margin-right: auto; }
        .category-list li { margin-bottom: 15px; }
        .category-list label { display: flex; align-items: center; cursor: pointer; font-size: 18px; }
        .category-list input[type="checkbox"] { margin-right: 15px; width: 20px; height: 20px; accent-color: #D98B96; }
        
        .result-category { margin-top: 30px; }
        .result-category h2 { text-align: left; }
        .result-list { list-style-type: '✓ '; padding-left: 25px; margin-bottom: 24px; }
        .result-list li { margin-bottom: 12px; padding-left: 10px;}

        @media (max-width: 768px) { h1 { font-size: 36px; } .container { margin: 20px 0 0 0; padding: 20px; border-radius: 0; } }
    </style>
</head>
<body>
    <div class="container">

        <div id="welcome-page" class="page-section">
            <h1>It's 2 PM. Do You Know What's Stealing Your Joy?</h1>
            <p class="subheadline">This Free 2-Minute Assessment Pinpoints Exactly Why You're Struggling & How To Get Back to Feeling Like You.</p>
            <p class="text-center">If you're a new mom feeling overwhelmed, you're not alone. But "postpartum" isn't a single problem—it's a collection of challenges that are unique to <span class="emphasis">your</span> body, <span class="emphasis">your</span> baby, and <span class="emphasis">your</span> life.</p>
            <p class="text-center"><strong>Stop guessing what's wrong. Knowing the true source of your struggles is the first step to solving them.</strong></p>
            <button id="start-survey-btn" class="cta-button">Start The Free Assessment</button>
            <p class="text-center" style="font-size: 16px; margin-top: -15px;">Get your personalized results instantly.</p>
        </div>
        
        <div id="survey-engine" class="page-section">
            <div id="progress-bar-container"><div id="progress-bar"></div></div>
            <div id="survey-content">
                <!-- All dynamic content (categories, questions, lead form) will be injected here -->
            </div>
        </div>

        <div id="loading-page" class="page-section">
            <h1>Analyzing Your Assessment...</h1>
            <p class="subheadline" id="loading-text">Getting started...</p>
            <div class="spinner"></div>
            <p>We're cross-referencing your unique challenges to build your personalized support plan.</p>
        </div>
        
        <div id="results-page" class="page-section">
             <!-- Results will be dynamically inserted here -->
        </div>

    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        
        const surveyStructure = <?php echo json_encode($survey_structure); ?>;
        const categories = <?php echo json_encode($categories); ?>;
        let userDetails = {};
        let questionQueue = [];
        let userAnswers = {};
        let currentQuestionIndex = 0;

        const pageElements = {
            welcome: document.getElementById('welcome-page'),
            surveyEngine: document.getElementById('survey-engine'),
            loading: document.getElementById('loading-page'),
            results: document.getElementById('results-page')
        };
        const surveyContent = document.getElementById('survey-content');
        const startBtn = document.getElementById('start-survey-btn');
        const progressBar = document.getElementById('progress-bar');
        const loadingText = document.getElementById('loading-text');

        function showPage(pageId) {
            Object.values(pageElements).forEach(page => page.classList.remove('active'));
            if(pageElements[pageId]) {
                pageElements[pageId].classList.add('active');
            }
            window.scrollTo(0, 0);
        }
        
        function displayCategorySelector() {
            let categoryHTML = `
                <form id="category-form">
                    <h2>Step 1: Where do you need support?</h2>
                    <p class="text-center">Select all the areas that feel challenging right now. We'll only ask you questions about the topics you choose.</p>
                    <ul class="category-list">
                        ${categories.map(cat => `
                            <li>
                                <label>
                                    <input type="checkbox" name="categories[]" value="${cat}">
                                    ${cat}
                                </label>
                            </li>
                        `).join('')}
                    </ul>
                    <button type="submit" class="cta-button">Continue</button>
                </form>
            `;
            surveyContent.innerHTML = categoryHTML;
            updateProgress(0, 1); // Progress is 0 out of total steps
            
            document.getElementById('category-form').addEventListener('submit', handleCategorySelection);
        }
        
        function handleCategorySelection(e) {
            e.preventDefault();
            const selectedCategories = Array.from(document.querySelectorAll('input[name="categories[]"]:checked')).map(cb => cb.value);
            if (selectedCategories.length === 0) {
                alert('Please select at least one area where you need support.');
                return;
            }
            buildQuestionQueue(selectedCategories);
            currentQuestionIndex = 0;
            displayQuestion();
        }

        function buildQuestionQueue(selectedCategories) {
            questionQueue = [];
            selectedCategories.forEach(categoryName => {
                if (surveyStructure[categoryName]) {
                    surveyStructure[categoryName].forEach(qData => {
                        questionQueue.push({ ...qData, category: categoryName });
                    });
                }
            });
        }
        
        function displayQuestion() {
            if (currentQuestionIndex >= questionQueue.length) {
                displayLeadCapture();
                return;
            }
            
            updateProgress(currentQuestionIndex, questionQueue.length);
            const q = questionQueue[currentQuestionIndex];
            surveyContent.innerHTML = `
                <div class="survey-question">
                    <h3>${q.question}</h3>
                    <div class="survey-buttons">
                        <button type="button" class="cta-button survey-btn" onclick="handleAnswer('yes')">Yes</button>
                        <button type="button" class="cta-button survey-btn" style="background-color: #7f8c8d;" onclick="handleAnswer('no')">No</button>
                    </div>
                </div>
            `;
        }

        window.handleAnswer = function(answer) {
            const key = questionQueue[currentQuestionIndex].key;
            userAnswers[key] = {
                question: questionQueue[currentQuestionIndex].question,
                category: questionQueue[currentQuestionIndex].category,
                answer: answer
            };
            currentQuestionIndex++;
            displayQuestion();
        }

        function displayLeadCapture() {
            updateProgress(1, 1); // Progress bar is full
            surveyContent.innerHTML = `
                <div class="lead-capture text-center">
                    <h2>You're almost there! Just one last step...</h2>
                    <p>Enter your details below to get your personalized results and battle plan instantly.</p>
                    <form id="lead-capture-form">
                        <input type="text" id="user-name" class="input-field" placeholder="Your First Name" value="<?php echo $pre_name; ?>" required>
                        <input type="email" id="user-email" class="input-field" placeholder="Your Best Email Address" value="<?php echo $pre_email; ?>" required>
                        <input type="tel" id="user-phone" class="input-field" placeholder="Your Phone Number (Optional)" value="<?php echo $pre_phone; ?>">
                        <button type="submit" class="cta-button">See My Personalized Results!</button>
                    </form>
                </div>`;
            document.getElementById('lead-capture-form').addEventListener('submit', handleLeadCapture);
        }
        
        function handleLeadCapture(e) {
            e.preventDefault();
            userDetails = {
                name: document.getElementById('user-name').value,
                email: document.getElementById('user-email').value,
                phone: document.getElementById('user-phone').value
            };
            startLoadingAnimation();
        }

        function updateProgress(current, total) {
            const progress = total > 0 ? (current / total) * 100 : 0;
            progressBar.style.width = progress + '%';
            progressBar.textContent = `${Math.round(progress)}%`;
        }
        
        function startLoadingAnimation() {
            showPage('loading');
            const messages = [
                "Analyzing your responses...",
                "Cross-referencing common postpartum challenges...",
                "Identifying your key areas of need...",
                "Preparing your personalized support plan..."
            ];
            let msgIndex = 0;
            loadingText.textContent = messages[msgIndex];

            const textInterval = setInterval(() => {
                msgIndex++;
                if (msgIndex < messages.length) {
                    loadingText.style.opacity = 0;
                    setTimeout(() => {
                        loadingText.textContent = messages[msgIndex];
                        loadingText.style.opacity = 1;
                    }, 400);
                } else {
                    clearInterval(textInterval);
                }
            }, 1000);

            setTimeout(displayResults, 4500);
        }

        function displayResults() {
            let resultsHTML = `<h1>Your Personalized Support Plan</h1>`;
            const resultsByCategory = {};

            Object.values(userAnswers).forEach(data => {
                if (data.answer === 'yes') {
                    if (!resultsByCategory[data.category]) {
                        resultsByCategory[data.category] = [];
                    }
                    resultsByCategory[data.category].push(data.question);
                }
            });

            if (Object.keys(resultsByCategory).length === 0) {
                resultsHTML += `
                    <div class="result-category">
                        <h2>Great News, ${userDetails.name || 'Mama'}!</h2>
                        <p class="text-center">Based on your answers, it seems you're navigating things incredibly well right now! This is wonderful to see. Remember that the postpartum journey has its ups and downs, so feel free to come back anytime a new challenge arises.</p>
                    </div>`;
            } else {
                resultsHTML += `<p class="subheadline" style="font-size: 20px;">Hi ${userDetails.name || 'Mama'}, here are the key areas we've identified and your recommended first steps.</p>`;
                for (const category in resultsByCategory) {
                    resultsHTML += `
                        <div class="result-category">
                            <h2>${category}</h2>
                            <p>It looks like you're facing some challenges here. Specifically, you mentioned:</p>
                            <ul class="result-list">
                                ${resultsByCategory[category].map(q => `<li>${q}</li>`).join('')}
                            </ul>
                        </div>`;
                }
            }
            resultsHTML += `<div class="text-center" style="margin-top:40px;"><button onclick="window.location.reload()" class="cta-button" style="background-color:#7f8c8d;">Start Over</button></div>`;
            
            pageElements.results.innerHTML = resultsHTML;
            showPage('results');
        }

        startBtn.addEventListener('click', () => {
            showPage('surveyEngine');
            displayCategorySelector();
        });

        showPage('welcome');
    });
    </script>
</body>
</html>